<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keranjangs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transaksi_id')->constrained(
                table: 'transaksis',
                indexName: 'keranjang_transaksi_id'
            )->onDelete('cascade');
            $table->foreignId('produk_id')->constrained(
                table: 'produks',
                indexName: 'keranjang_produk_id'
            )->onDelete('cascade');
            $table->double('berat');
            $table->double('harga');
            $table->double('jumlah');
            $table->double('diskon');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keranjangs');
    }
};
